/*
|============================================================================
|
|       Copyright (C) 2011 ProSoft Technology. All rights reserved.
|
|  File:             ntpset.h
|
|  Class(es):        
|
|  Inherits From:    
|
|  Summary:          
|
|  Project(s):       Common Utility
|
|  Subsystem:        ProLinx
|
|  Contributors:     Henry Yu(HYU)
|
|  Description:      This file contains the definitions needed for NTP.
|
|  Notes:            
|
|
|============================================================================
|  Version     Date     Author  Change    Description
|----------------------------------------------------------------------------
|  Build     12/06/2011 HYU      Created.
|============================================================================
*/

#ifndef NTPSET_H_FILE
#define NTPSET_H_FILE


# ifdef __cplusplus
extern "C"
{
# endif


typedef struct
{
    char  ntp_ip[20];    //NIST, Boulder, Colorado
    short ntp_timeZone;  //hours offset from GMT
    short ntp_dst;       //Daylight Savings Time Used 0=No, !0=Yes
    int	  status_offset; // DB register for status of NTP

} NTP_CONFIG_DATA;


typedef struct
{
    unsigned short  valid;       //time is valid 0=No, 1=Yes
    unsigned short  req_count;   //number of times requests issued
    unsigned short  resp_count;  //number of responses to requests
    unsigned short  comp_count;  //number of times computation made
    unsigned short  set_count;   //number of times clock set
    unsigned short  tmout_count; //number of timeout errors
    long long       offset;	     // offset of our time and ntp server time in seconds.
    
} NTP_STATUS_DATA;


int NTP_LoadConfig(char * fname, NTP_CONFIG_DATA * config, int Max_DB_addr);
int NTP_ApplyConfig(char * fname);

int ediag_ntp_config(char * buff, int buff_len);
int diagNtpConfig(char * buff, int buff_len);
int ediag_ntp_status(char * buff, int buff_len);
int diagNtpStatus(char * buff, int buff_len);
int ntp_update_status( void );
void ntp_get_status( NTP_STATUS_DATA * ntp_ptr );

# ifdef __cplusplus
}
# endif

#endif //#define NTPSET_H_FILE

