/*
|============================================================================
|
|       Copyright (C) 2011 ProSoft Technology. All rights reserved.
|
|  File:             PLXJumpers.c
|
|  Class(es):        
|
|  Inherits From:    
|
|  Summary:          
|
|  Project(s):       PLX Utility
|
|  Subsystem:        Common
|
|  Contributors:     Henry Yu(HYU)
|					 Peter Boldt
|
|  Description:      
|
|  Notes:            
|
|
|============================================================================
|  Version     Date     Author  Change    Description
|----------------------------------------------------------------------------
|  Build     8/31/2011 HYU              Created.
|  			11/30/2012 PJB				Modified for DATM3
|============================================================================
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <assert.h>

#include "ocxbpapi.h"

#include "plxjumpers.h"



/*****************************************************************************
 * Purpose: Function that determines if the module is running in setup mode
 *
 * Params: Nothing
 *
 * Returns: -1 if some error occurs
 *           the state of the jumpers. (see OCX manual )
 *
 * Comments:
 *
******************************************************************************/
int readJumpers( void )
{
	OCXHANDLE	handle;
	int 		jumper_value;
	int			result;
	int			return_value = -1;


	// open OCX without Backplane
	result = OCXcip_OpenNB( &handle );

	// if open succeeded then read the jumper value

	if ( result == OCX_SUCCESS )
	{
		result = OCXcip_GetSwitchPosition( handle, &jumper_value );

		if ( result == OCX_SUCCESS )
		{
			return_value = jumper_value;
		}

		// close the backplane driver
		OCXcip_Close( handle );
	}

    return( return_value );
}


/*****************************************************************************
 * Purpose: Function that determines if the module is running in setup mode
 *
 * Params: Nothing
 *
 * Returns: 0 if not in setup mode
 *          1 if setup jumper is installed
 *
 * Comments:
 *
******************************************************************************/
int inSetupMode()

{
	OCXHANDLE	handle;
	int 		jumper_value;
	int			result;


	//Open the CIP BP driver without BP access
	result = OCXcip_OpenNB( &handle );

	// if open succeeded then read the jumper value

	if ( result == OCX_SUCCESS )
	{
		result = OCXcip_GetSwitchPosition( handle, &jumper_value );
	}

	// close the backplane driver
	OCXcip_Close( handle );

	// bit 1 == 1 Setup(1) jumper installed.

	if ( jumper_value & 0x01 )
		result = 0;
	else
		result = 1;

	return( result );

}

