/*=======================================================================
=                           INCLUDE FILES                               =
=======================================================================*/

#include    <stdlib.h>
#include    <mem.h>
#include    <stdio.h>
#include 	<dos.h>
#include 	"mvidf1hm.h"
#include 	"ktypes.h"
#include    "system.h"
#include    "kernel.h"
/*=======================================================================
=                       MAIN ENTRY POINT                                =
=======================================================================*/

/************************************************************************
*
*     Entry point:                                                      
*       main                                           
*
*     Description:                                                      
*		This is a sample program for the Half-Duplex Master DF1 API.  This 
*		program performs the following functions:
*			1. Fetches and displays the series and revision number of
*				the half-duplex master DF1 API. 
*			2. Opens a half-duplex master DF1 engine on Port 3
*			3. Constructs and transmits an ECHO command packet
*			4. Verifies transmission of the ECHO command packet
*			5. Monitors for reception of a response packet from a DF1 slave
*				device. 
*			6. Verifies reception of the ECHO response packet
*			7. Closes the half-duplex slave DF1 engine running on Port 3.  
*     Arguments:                                                        
*       none
*
*     External effects:                                                 
*
*
*     Return value:                                                     
*       none
*
*-----------------------------------------------------------------------
*     Notes:                                                            
*
*
************************************************************************/
void main(void)
{
HDMCFG Port3Cfg;           		// Allocate data for port 3	DF1 configuration

BYTE DF1_Resp_Pkt[256];
BYTE DF1_Source_Pkt[256];
WORD Pkt_Len;
WORD i;
SRCXMT DF1_Stat;
RSPRCV DF1_Resp_Stat;
MVIHDMVERSIONINFO verinfo;
#define DLE 0x10

int rc;

	Port3Cfg.Baud = BAUD_9600;
	Port3Cfg.Parity = PARITY_NONE;
	Port3Cfg.Stop = STOPBITS1;
	Port3Cfg.DupPacket = DUP_PACKET_DIS;
	Port3Cfg.ErrorDet = CRC_ERROR_CHK;
	Port3Cfg.Station = 0x80;
	Port3Cfg.MsgRetries = 0x03;
	Port3Cfg.Handshake = HSHAKE_NONE;
	Port3Cfg.RTSSend = 70;
	Port3Cfg.RTSOff = 40;
	Port3Cfg.ReplyMsgWait = 300;
	Port3Cfg.ACKTimeout = 300;
	Port3Cfg.MsgApplTimeout = 30;
	Port3Cfg.PollingMode = MSG_NO_SLAVE_ALLD;
	Port3Cfg.ComPort = COM3;
	rc = MVIdf1_HDMOpenPort(&Port3Cfg);
	if(rc == MVI_SUCCESS)
	{
    	printf("\nPort opened successfully\n");
		if(MVI_SUCCESS == MVIdf1_HDMGetVersionInfo(&verinfo))
		{
			printf("\nLibrary Series %d, Rev %d\n", verinfo.APISeries, verinfo.APIRevision);
		}
		else
		{
			printf("\nVersion information retrieval failed\n");
		}
						// Build command packet
		i = 0x00;
		DF1_Source_Pkt[i++] = 0x12;		//DST
		DF1_Source_Pkt[i++] = Port3Cfg.Station;	//SRC
		DF1_Source_Pkt[i++] = 0x06;		//CMD
		DF1_Source_Pkt[i++] = 0x00;		//STS
		DF1_Source_Pkt[i++] = 0x08;		//TNS MSB
		DF1_Source_Pkt[i++] = 0x03;		//TNS LSB
		DF1_Source_Pkt[i++] = 0x00;		//FNC
		DF1_Source_Pkt[i++] = 0x55;		//DATA
		DF1_Source_Pkt[i++] = 0xAA;		//DATA
		DF1_Source_Pkt[i++] = 0x01;		//DATA
		DF1_Source_Pkt[i++] = 0x02;		//DATA
		DF1_Source_Pkt[i++] = 0x03;		//DATA
		DF1_Source_Pkt[i++] = 0x04;		//DATA
		DF1_Source_Pkt[i++] = 0x05;		//DATA
		DF1_Source_Pkt[i++] = 0x06;		//DATA
		DF1_Source_Pkt[i++] = 0xFF;		//DATA
		Pkt_Len = i;
		if(MVI_SUCCESS == (MVIdf1_HDMPutPkt(COM3,DF1_Source_Pkt,&Pkt_Len)))
		{
			printf("\nCommand packet queued for transmission\n");
			printf("\nMonitoring transmission status\n");
			while(MVI_ERR_NOSTAT == MVIdf1_HDMGetPktStat(COM3,&DF1_Stat))
			{};
			while(MVIDF1_XMITTING == DF1_Stat.XmitStatus)
			{
				if(MVI_SUCCESS != MVIdf1_HDMGetPktStat(COM3,&DF1_Stat))
				{					// Status retrieval failed
					printf("\nPacket status retrieval error !\n");
								// Force exit
					DF1_Stat.XmitStatus = MVIDF1_FAILED;
				}
			}
			if(DF1_Stat.XmitStatus == MVIDF1_SUCCESS)
			{
				printf("\nPacket transmission successful\n");
				printf("\nWaiting for response packet\n");
				while(MVI_ERR_NODATA == MVIdf1_HDMGetRespPkt(COM3,
						DF1_Resp_Pkt,
						&Pkt_Len,
						&DF1_Resp_Stat))
				{};
				if(DF1_Resp_Stat.RespStatus == MVI_RESP_VALID)
				{
					printf("\nResponse packet received\n");
				}
				else
				{
					if(DF1_Resp_Stat.RespStatus == MVI_RESP_TIMEOUT)
					{
						printf("\nResponse packet not received\n");
						printf("\nResponse timeout exceeded\n");
					}
				}
			}
			else
			{
				printf("\nPacket transmission failed\n");
			}	 
		}
		else
		{
			printf("\nQueueing of command packet failed\n");
		}
	}
	rc = MVIdf1_HDMClosePort(COM3);
	if(rc == MVI_SUCCESS)
	{
    	printf("\nPort closed successfully\n");
	}
	else
	{
		if(rc == MVI_ERR_NOACCESS)
		{
    		printf("\nPort already closed\n");
		}
		else
		{
   			printf("\nPort number invalid\n");
		}
	}		
	exit(0);
}
