;***	EXEHDR.INC -- Embedded DOS .EXE File Header.
;
;1.	Functional Description.
;	This structure defines the layout of a real-mode program header
;	that is of the .EXE type.  If the signature in the file does not
;	contain 'MZ' or 'ZM', then the file is a "COM" file and this
;	structure is not present.  If the signature is correct, then
;	the fields in this header contain information about how the
;	program is to be loaded.  The loader in DOSEXEC.ASM uses this
;	information.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

EXEHDR		struc
exehdr_sig	dw	?	; 'ZM' or 'MZ' -- Mark Zbikowski's signature.
exehdr_imgmod	dw	?	; image length mod 512.
exehdr_imglen	dw	?	; image length in 512-byte pages (incl. hdr).
exehdr_nreloc	dw	?	; fixups in relocation table.
exehdr_image	dw	?	; byte offset of image text in this file.
exehdr_bss	dw	?	; extra paragraphs above load needed for BSS.
exehdr_maxbss	dw	?	; maximum paragraphs used above load for BSS.
exehdr_ss	dw	?	; initial SS (unrelocated).
exehdr_sp	dw	?	; initial SP.
exehdr_checksum dw	?	; checksum, ~(Ew(i)).
exehdr_ip	dw	?	; initial IP.
exehdr_cs	dw	?	; initial CS (unrelocated).
exehdr_reltbl	dw	?	; byte offset of relocation tbl in this file.
exehdr_overlay	dw	?	; overlay number for some weird linkers.
EXEHDR		ends
