////////////////////////////////////////////////////////////////////////////
//
//  MVI69ADM-SerialOut.c
//  This program has been modified from the previous work of others to serve
//  as a starting point for the fast implementation of custom protocols for
//  MVI customers
//
//  Original work:
//  Rich Reynolds, Vital Computer Solutions
//  (c) 1999, Vital Computer Solutions
//  All Rights Reserved
//
//  Copyright (c) 2000-2006, ProSoft Technology
//  Date    : 05/09/00  Develop LAS module for UK customer
//  Date    : 06/20/00  Develop GEN module
//
//  Ken D. Hopwood
//  Joe Amorntrakul, ProSoft Technology
//  Date    : 04/08/05  Develop Sample module
//  10/25/2006		KDH	Added support for Digital Mars Compiler
//
//  Environment:	MVI
//						GS-DOS
//						Borland C/C++ Compiler v5.02 (16-bit DOS)
//						Digital Mars C/C++ Compiler v8.49 (16-bit DOS)
//
// ProSoft Technology, Inc. grants you a non-exclusive license to use, modify
// and re-distribute this program provided that this copyright notice and
// license appear on all copies of the software.
//
// Software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR
// IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
// HEREBY EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE IS ASSUMED
// BY THE LICENSEE.
//
// PROSOFT TECHNOLOGY, INC. AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
// DAMAGES SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
// DISTRIBUTING SOFTWARE.  IN NO EVENT WILL PROSOFT TECHNOLOGY, INC. OR ITS
// LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
// INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
// CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
// OR INABILITY TO USE SOFTWARE, EVEN IF PROSOFT TECHNOLOGY, INC. HAS BEEN
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//
////////////////////////////////////////////////////////////////////////////


#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>

#include "MVI69ADM-SerialOut.H"

int setup_module(void);
int shutdown_module(void);
int startup(void);

//---------------------- do not edit following code -----------------------
static void interrupt intctl_c(void);
static void interrupt intcrit(void);

// Ctrl-C signal handling function.  When a Ctrl-C is recognized, this function
// is called.  The function ignores the request and must reinstall the signal
// handler for future calls.
static void interrupt intctl_c(void)
{
	return;
}

static void interrupt intcrit(void)
{
	_AX = 0;   // ignore critical error
}
//--------------------- ok to edit following code ---------------------------

void main(void)
{
	BYTE str[30];              // buffer used for port 1
   int len, i;             // buffer length variables used in code
   int returnCode, serialCount=0;

#ifdef __DMC__
	extern int _8087;

	_8087 = 0; /* never use 80x87 Math Coprocessor */
#endif

	/* enable console on COM1 */
	ADM_SetConsolePort(COM1);
	/* set console to 57600 baud */
	ADM_SetConsoleSpeed(COM1, 57600L);

	/* open ADM API and get handle */
	if(ADM_Open(&adm_handle) != ADM_SUCCESS)
	{
		printf("\nFailed to open ADM API... exiting program\n");
		exit(1);
	}

	/* send status message to the status/debug port */
	printf("\nProgram Initialization....\n");
	if(!setup_module())         // Initialize hardware and load drivers
	{
		shutdown_module();      // if fail on init then shutdown
		return;
	}

   // Main loop for program ---------------------------------------------------
	for(;;)
	{
		// Set APP LED on
      ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_ON);
		// Set BP LED on
      ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER2, ADM_LED_ON);
		// read image from backplane ------ offset of 4 to skip status data ------
   	if((returnCode=MVIbp_ReadOutputImage(interface_ptr->handle, rdbuff,	0, 30)) == MVI_SUCCESS)
		{
		// Set BP LED off
      	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER2, ADM_LED_OFF);

         str[0] = rdbuff[0];
      	for(i=2; i<12; i++) str[i-1] = rdbuff[i];
         str[11] = '\0';

		   if(rdbuff[1] == 1000 && rdbuff[0] != serialCount)
		   {
      		// Port 1 handler logic -------------------------------------------------
      		// Put chars out to COM port. If end of string is found, process string
      		serialCount = rdbuff[0];
      		if(MVIsp_Puts(COM2, &str[0], '\0', &len, TIMEOUT_ASAP) != MVI_SUCCESS)
      		{
      		   printf("Error write to port 1\n");
      		}
         }
         else if(rdbuff[1] == 2000 && rdbuff[0] != serialCount)
         {
      		// Port 2 handler logic -------------------------------------------------
      		// Put chars out to COM port. If end of string is found, process string
      		serialCount = rdbuff[0];
      		if(MVIsp_Puts(COM3, &str[0], '\0', &len, TIMEOUT_ASAP) != MVI_SUCCESS)
      		{
      		   printf("Error write to port 2\n");
      		}
   		}

		   // Set APP LED off
      	ADM_SetLed(adm_handle, interface_ptr, ADM_LED_USER1, ADM_LED_OFF);
		}
		else
		   printf("Error reading from BP: %d\n", returnCode);

      // Key Board Input ------------------------------------------------------
   	if(kbhit())
   	{
   		if(getch() == 27)
   		{
		      shutdown_module();      // if fail on init then shutdown
		      exit(1);
   		}
   		else
	         printf("Press Esc to Exit.\n\n");
   	}
	}  // End Main loop
}


///////////////////////////////////////////////////////////////////////////////
//
// This function is used to setup the module's hardware and load device
// drivers required by the application.  Most of the items to look at closely
// are going to be related to the serial port configuration value at the top of
// of the function.
//
// Input : None.
// Output: The function returns a value of 1 if successful and 0 if not.
//
///////////////////////////////////////////////////////////////////////////////

int setup_module(void)
{
	int se;

	/******************************************************************
		This section is required for the ADM API to function.
		The names of the structures may be changed to suit the
		developer's needs.  The interface structure must be initialized
		before it can be used.
	*******************************************************************
	*/

	/* initialize structure pointers */
	interface_ptr = &interface;
	interface.adm_bt_data_ptr = &bt_data;
	interface.adm_bt_err_ptr = &bt_err;

	memset(interface.adm_bt_data_ptr, 0, sizeof(ADM_BT_DATA));
	memset(interface.adm_bt_err_ptr, 0, sizeof(ADM_BLK_ERRORS));

	while(ADM_BtOpen(adm_handle, interface_ptr, 0) != MVI_SUCCESS){
   	ADM_BtClose(adm_handle, interface_ptr);	   
	}
   printf("Successfully open Backplane\n");

	MVIbp_GetVersionInfo(interface_ptr->handle, &verinfo);
	MVIsp_GetVersionInfo(&spverinfo);
	ADM_GetVersionInfo(adm_handle, &adm_version);

	//----------- do not edit next 6 lines of code---------------------------
	disable();
	setvect(0x24, intcrit);     // install in ISR handler for CTRL-C
	setvect(0x23, intctl_c);    // install in ISR handler for CTRL-C
	setvect(0x1B, intctl_c);    // install in ISR handler for CTRL-Break
	setcbrk(0);                 // force DOS to ignore Ctrl-C
	enable();

	// Open serial interface API
	// Set comm parameters
	printf("Open Communication Port 1 9600 8 1 None....");
	se = MVIsp_Open(COM2, BAUD_9600, PARITY_NONE, WORDLEN8, STOPBITS1);
	if(se != MVI_SUCCESS){
	   printf("Unsuccessfully!\n");
		return 0;
	}
	else
	   printf("Successfully!\n");

	printf("Open Communication Port 2 9600 8 1 None....");
	se = MVIsp_Open(COM3, BAUD_9600, PARITY_NONE, WORDLEN8, STOPBITS1);
	if(se != MVI_SUCCESS){
	   printf("Unsuccessfully!\n");
		return 0;
	}
	else
	   printf("Successfully!\n");

	// Set comm handshaking
	MVIsp_SetHandshaking(COM2, HSHAKE_NONE);
	MVIsp_SetHandshaking(COM3, HSHAKE_NONE);

	// Set module status LED
	MVIbp_SetModuleStatus(adm_handle, MVI_MODULE_STATUS_OK);

	// Set user LED1 on to indicate program running
	MVIbp_SetUserLED(adm_handle, MVI_LED_USER1, MVI_LED_STATE_ON);

	printf("\nVERSION INFORMATION:\n\n\
  %s\n\
  (c) 1999-2018, ProSoft Technology, Inc.\n\n\
  PRODUCT NAME CODE         : %s\n\
  SOFTWARE REVISION LEVEL   : %s\n\
  RUN NUMBER                : %s\n\n\
  BACKPLANE DRIVER VERSION  : %d.%d\n\
  BACKPLANE API VERSION     : %d.%d\n\
  SERIAL API VERSION        : %d.%d\n\
  ADM API VERSION           : %d.%d\n\n",
	"MVI69ADM",
	"ADM Serial Output Sample",
	"2.40",
	"12/06/2018",
	verinfo.BPDDSeries, verinfo.BPDDRevision,
	verinfo.APISeries, verinfo.APIRevision,
	spverinfo.APISeries, spverinfo.APIRevision,
	adm_version.APIRevisionMajor, adm_version.APIRevisionMinor);

	printf("Press Esc to Exit.\n\n");

	return 1;
}

///////////////////////////////////////////////////////////////////////////////
//
// This function is used to shutdown the module's hardware and device drivers.
//
// Input : None.
// Output: The function will always return a value of 1.
//
///////////////////////////////////////////////////////////////////////////////

int shutdown_module(void)
{
	MVIbp_SetUserLED(adm_handle, MVI_LED_USER1, MVI_LED_STATE_OFF);
	MVIbp_SetUserLED(adm_handle, MVI_LED_USER2, MVI_LED_STATE_OFF);
	MVIbp_SetModuleStatus(adm_handle, MVI_MODULE_STATUS_FAULTED);

	/* close the backplane driver */
	printf("Closing Backplane Driver....\n");
	ADM_BtClose(adm_handle, interface_ptr);
	/* close the com driver */
	printf("Closing Serial Port Driver....\n");
	MVIsp_Close(COM2);
	MVIsp_Close(COM3);

	return 1;
}

