/*
// PROGRAM NAME:  MTHELLO.C.
//
// FUNCTIONAL DESCRIPTION.
//	This program is probably the simplest example of using threads
//	to do work in parallel.  It is the multitasking equivalent of
//	the popular "hello world" example program.
//
//	This program is linked with GENERAL\LIB\OBJ\KERNEL.OBJ to gain
//	access to the kernel API.
//
// MODIFICATION HISTORY.
//	S. E. Jones	93/09/18.	#1.106, original.
//	S. E. Jones	95/08/17.	#3.0, added _loadds on thread functions.
//	S. E. Jones	95/12/06.	#6-XL v40, called LeaveCritSect on exit.
//
// INPUTS.
//	none.
//
// OUTPUTS.
//	none.
//
// COMMAND LINE ARGUMENTS.
//	none.
//
// NOTICE:  Copyright (C) 1993-1995 General Software, Inc.
*/

#include "..\inc\kernel.h"
#include "..\inc\system.h"
#include <conio.h>

THREAD _loadds FirstThread ()
{
    while (TRUE) {
	EnterCriticalSection ();
	putch ('1');		// print a character to the screen.
	LeaveCriticalSection ();
    }
} // FirstThread

THREAD _loadds SecondThread ()
{
    while (TRUE) {
	EnterCriticalSection ();
	putch ('2');		// print a character to the screen.
	LeaveCriticalSection ();
    }
} // SecondThread

VOID main ()
{
    HANDLE Thread1, Thread2;
    UCHAR ch;

    Thread1 = AllocateThread (FirstThread);  // start first thread.
    Thread2 = AllocateThread (SecondThread); // start next thread.

    while (TRUE) {
	EnterCriticalSection ();
	if (kbhit ()) {
	    LeaveCriticalSection ();
	    break;
	}
	LeaveCriticalSection ();
	PassTimeSlice ();
    }
    // ch = getch ();				// wait for a keypress.

    AbortThread (Thread1);		     // stop first thread.
    AbortThread (Thread2);		     // stop second thread.
    printf ("All worker threads have been aborted.\n");
    exit (0);
} // mthello.c
