//
// PROGRAM NAME:  TESTIOH.C.
//
// FUNCTIONAL DESCRIPTION.
//	This module comprises the C component of the IOHELP test program,
//	which verifies that the I/O helper API is working correctly.
//
// MODIFICATION HISTORY.
//	S. E. Jones	92/01/14.	#1.095, original.
//	S. E. Jones	93/09/10.	#1.106, moved to C 8.0.
//
// NOTICE:  Copyright (C) 1992-1995 General Software, Inc.
//

#include <stdlib.h>
#include <string.h>
#include "../inc/system.h"		// general Embedded DOS stuff.
#include "../inc/kernel.h"		// kernel API.
#include "../inc/iohelp.h"		// I/O helper API.

static UCHAR Buffer [512];

VOID main (
    USHORT argc,
    UCHAR *argv [])
{
    STATUS rc;
    HANDLE ih, oh;
    USHORT BytesRead, BytesWritten;

    printf ("TESTIOH V1.0 Copyright (C) 1992-1995 General Software Inc.\n");
    if (argc != 3) {
	printf ("Usage:  TESTIOH input_filename  output_filename\n");
	exit (0);
    }

    rc = IoOpen (argv [1], 0, &ih);
    if (rc != DOSERR_SUCCESS) {
	printf ("Open of '%s' returned %u.\n", argv [1], rc);
	exit (0);
    }
    rc = IoCreate (argv [2], 0, 0, &oh);
    if (rc != DOSERR_SUCCESS) {
	printf ("Create of '%s' returned %u.\n", argv [2], rc);
	IoClose (ih);
	exit (0);
    }
    rc = IoRead (ih, Buffer, 512, &BytesRead);
    if (rc != DOSERR_SUCCESS) {
	printf ("Read on '%s' returned %u.\n", argv [1], rc);
	IoClose (ih);
	IoClose (oh);
	exit (0);
    }
    printf ("Read %u bytes from input file (up to 512).\n", BytesRead);

    rc = IoWrite (oh, Buffer, BytesRead, &BytesWritten);
    if (rc != DOSERR_SUCCESS) {
	printf ("Write on '%s' returned %u.\n", argv [2], rc);
	IoClose (ih);
	IoClose (oh);
	exit (0);
    }
    printf ("Wrote %u bytes to output file (up to %u).\n", BytesWritten, BytesRead);
    IoClose (ih);
    IoClose (oh);
    exit (0);
} // testioh.c
