;***	IORP.INC -- Embedded DOS I/O Request Packet Structures.
;
;1.	Functional Description.
;	This include file contains the structure definitions for the
;	internal I/O request packets used in Embedded DOS.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	92/01/06.	#1.095, added BIGDISK note.
;	S. E. Jones	92/02/01.	#1.096, fixed huge IORP_READ/WRITE layout.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

;***	IORP_HEADER - I/O Request Packet Header.
;
;	This structure defines the layout of an I/O Request Packet header,
;	used as the basic control block to pass to device drivers.

IORP		struc
iorp_len	db	?		; length of request header.
iorp_unit	db	?		; unit number for this request.
iorp_cmd	db	?		; command code.
iorp_status	dw	?		; device driver's return status code.

;	The following fields are used internally by Embedded DOS and are never
;	accessed by device drivers themselves.	They are documented as
;	"reserved" in the DOS literature.

iorp_linkage	dd	?		; pointer to next IORP in chain.
		db	4 dup (?)	; reserved for Embedded DOS.
IORP		ends

;	IORP status bitflags and field masks.

IORPSTATUS_ERROR =	8000h		; indicates error.
IORPSTATUS_RETMASK=	00ffh		; error code if IORPSTATUS_ERROR.
IORPSTATUS_DONE  =	0100h		; if operation complete.
IORPSTATUS_BUSY  =	0200h		; if operation in progress.

;***	IORP_INIT - I/O Request Packet for Initialize Driver Function.
;
;	This structure defines the layout of an IORP for the Init Function.

IORP_INIT		struc
			db	(type IORP) dup (?) ; common stuff.

iorp_init_units         db	?		; number of units.
iorp_init_break         dd	?		; break address.
iorp_init_bpbptr	dd	?		; BIOS parameter block pointer.
iorp_init_firstunit	dw	?		; 1st unit number assigned to drvr.
IORP_INIT		ends

iorp_init_cmdtail	equ	iorp_init_bpbptr; IN ptr to DEVICE= string.

;***	IORP_MEDIA_CHECK - I/O Request Packet for Media Check Function.
;
;	This structure defines the layout of an IORP for the
;	Media Check function.

IORP_MEDIA_CHECK	struc
			db     (type IORP) dup (?) ; common stuff.

iorp_mc_media		db	?		; media descriptor byte.
iorp_mc_changed         db	?		; change code, defined below.
iorp_mc_volid		dd	?		; ptr to prev volume ID. (DOS 3.0).
IORP_MEDIA_CHECK	ends

IORP_MC_CHANGEFLAG_CHANGED = -1         ; if it has changed for sure.
IORP_MC_CHANGEFLAG_UNKNOWN = 0		; if we don't really know.
IORP_MC_CHANGEFLAG_SAFE    = 1		; if it definitely hasn't changed.

;***	IORP_BUILD_BPB - I/O Request Packet for Build BPB Function.
;
;	This structure defines the layout of an IORP for the
;	Build BPB function.

IORP_BUILD_BPB		struc
			db     (type IORP) dup (?) ; common stuff.

iorp_bb_media		db	?		; media descriptor.
iorp_bb_address         dd	?		; transfer address.
iorp_bb_bpb		dd	?		; FWA, new BIOS Parameter Block.
IORP_BUILD_BPB		ends

;***	IORP_READ - I/O Request Packet for Read Function.
;
;	This structure defines the layout of an IORP for the Read function.

IORP_READ		struc
			db     (type IORP) dup (?) ; common stuff.

iorp_read_media         db	?		; media descriptor byte.
iorp_read_address	dd	?		; memory address for transfer.
iorp_read_count         dw	?		; byte/sector count value.
iorp_read_sector	dw	?		; starting sector value.

;	The following fields are extensions of the IORP if the block driver
;	supports LSN's bigger than 65535.  It tells DOS this by setting the
;	DEVATR_BIGDISK bit in its device attributes word.  These fields are
;	ignored by other drivers.

iorp_read_volid         dd	?		; output: volume identifier.
iorp_read_lsn32         dd	?		; 32-bit LSN if sector==0xffff.
IORP_READ		ends

iorp_read_charbuf	equ	iorp_read_media ; single-character buffer.

;***	IORP_WRITE - I/O Request Packet for Write Function.
;
;	This structure defines the layout of an IORP for the Write function.

IORP_WRITE		struc
			db     (type IORP) dup (?) ; common stuff.

iorp_write_media	db	?		; media descriptor byte.
iorp_write_address	dd	?		; memory address for transfer.
iorp_write_count	dw	?		; byte/sector count value.
iorp_write_sector	dw	?		; starting LSN (ffff=huge sector).

;	The following fields are extensions of the IORP if the block driver
;	supports LSN's bigger than 65535.  It tells DOS this by setting the
;	DEVATR_BIGDISK bit in its device attributes word.  These fields are
;	ignored by other drivers.

iorp_write_volid	dd	?		; output: volume identifier.
iorp_write_lsn32	dd	?		; 32-bit LSN if sector==0xffff.
IORP_WRITE		ends

iorp_write_charbuf	equ	iorp_write_media ; single-character buffer.

;***	IORP_IOCTL - I/O Request Packet for IOCTL Function.
;
;	This structure defines the layout of an IORP for the generic IOCTL.
;	function code. This IS NOT the same as IOCTL Read or IOCTL Write.

IORP_IOCTL		struc
			db     (type IORP) dup (?) ; common stuff.

iorp_ioctl_category	db	?		; major (category) code.
iorp_ioctl_function	db	?		; minor (subfunction) code.
iorp_ioctl_si		dw	?		; contents of user's (SI) reg.
iorp_ioctl_di		dw	?		; contents of user's (DI) reg.
iorp_ioctl_paramblock	dd	?		; FWA, parameter block.

IORP_IOCTL		ends

GENERIC_SET_DEVICE_PARAMS =	40h
GENERIC_WRITE_TRACK	  =	41h
GENERIC_FORMAT_AND_VERIFY =	42h
GENERIC_GET_DEVICE_PARAMS =	60h
GENERIC_READ_TRACK	  =	61h
GENERIC_VERIFY		  =	62h

;***	IORP_READP - I/O Request Packet for Read Partial Sector Function.
;
;	This structure defines the layout of an IORP for the RPS function.

IORP_READP		struc
			db     (type IORP) dup (?) ; common stuff.

iorp_readp_media	db	?		; media descriptor byte.
iorp_readp_address	dd	?		; memory address for transfer.
iorp_readp_count	dw	?		; byte count value (NOT # sectors).
iorp_readp_offset	dw	?		; transfer offset from start of sector.
iorp_readp_sector	dd	?		; sector number to read.
IORP_READP		ends

;***	IORP_ND_READ - I/O Request Packet for Nondestructive Read.
;
;	This structure defines the layout of an IORP for the IORP_ND_READ
;	function.

IORP_ND_READ		struc
			db     (type IORP) dup (?) ; common stuff.
iorp_nr_char		db	?		; character buffer.
IORP_ND_READ		ends
