;***	ODE.INC -- Embedded DOS Object Directory Entry.
;
;1.	Functional Description.
;	This structure defines the layout of an object directory entry
;	returned by the FindFirst and FindNext DOS functions (4eh, 4fh).
;	See Ray Duncan's "Advanced MS-DOS" book, pg 363, for a description
;	of this area.  We added some fields to support general object types.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/02/17.	Added ode_fileid.
;	S. E. Jones	91/02/18.	Added ode_dirsect, ode_dirofs.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

ODE_NAME_SIZE	=	64		; maximum size of ode_name string.

ODE		struc
ode_handle	dw	?		; system handle used in search.
ode_type	dw	?		; type of object returned.
ode_host	db	8 dup (?)	; returned ASCIIZ host name.
ode_dirsec	dd	?		; sector # containing DDE.
ode_dirofs	dw	?		; offset of DDE within sector.
ode_fileid	dw	?		; for FAT, 1st cluster of file.
ode_access	db	?		; reserved for the future.
ode_attrib	db	?		; attribute of object.
ode_time	dw	?		; time stamp.
ode_date	dw	?		; date stamp.
ode_size	dd	?		; size of object in bytes.
ode_name	db	ODE_NAME_SIZE dup (?) ; DOS uses 13, but we extend it.
ODE		ends

ODE_TYPE_FILE		=	0	; this is a file/directory/volumelabel.
ODE_TYPE_MSGPORT	=	1	; this is a message port in the DFS.

ODE_ACCESS_READ         =	01h	; read access.
ODE_ACCESS_WRITE	=	02h	; write access.
ODE_ACCESS_EXEC         =	04h	; execute access.
ODE_ACCESS_DELETE	=	08h	; delete access.

ODE_FLAGS_READONLY	=	01h	; file is read-only.
ODE_FLAGS_HIDDEN	=	02h	; file is excluded from normal searches.
ODE_FLAGS_SYSTEM	=	04h	; file is excluded from normal searches.
ODE_FLAGS_VOLUME_LABEL	=	08h	; this is a volume label entry.
ODE_FLAGS_DIRECTORY	=	10h	; this is a subdirectory.
ODE_FLAGS_ARCHIVE	=	20h	; file has been modified since last archive.
ODE_FLAGS_RESERVED1	=	40h	; reserved.
ODE_FLAGS_RESERVED2	=	80h	; reserved.
