;***	SCSF.INC -- Embedded DOS System Call Stack Frame.
;
;1.	Functional Description.
;	The following structure defines the layout of the INT 21h
;	dispatcher's stack frame that is used to hold the user's
;	registers and his return address and flags across the call.
;
;	When the INT 21h handler gains control, it switches stacks
;	to a dynamically-allocated INT 21h stack, and then copies
;	the caller's old CS, IP, and flags, as well as all the
;	general operating registers, to the base of the new stack.
;	An IORP/FSRP scratch buffer is allocated in the structure
;	at its beginning, so that I/O routers can use it by simply
;	referring to the address in (SS:BP).  That means you can't
;	add anything in front of the IORP/FSRP buffer.
;
;	To use these fields in API functions dispatched by ISR21,
;	simply refer to their name relative to [bp].  For example:
;
;		mov	scsf_ax.[bp], DOSERR_INVALID_FUNCTION
;		or	scsf_flags.[bp], FL_CARRY  ; set the user's carry flag.
;
;		mov	es, scsf_es.[bp]
;		mov	bx, scsf_bx.[bp]	   ; (ES:BX) = FWA, param block.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/07/27.	#1.087, added PSP pointer.
;	S. E. Jones	91/08/06.	#1.089, added original user regs.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

SCSF		SEGMENT AT 0

;	The following area is a scratch IORP/FSRP for use by the
;	I/O system at any time.  It is put here because all of the
;	I/O routers require a scratch IORP/FSRP buffer at (SS:BP),
;	and (BP) seemed a natural to reserve as a pointer to the SCSF.

scsf_iorp	db	128 dup (?)	; much more than any IORP or FSRP.

;	The user process state.  An API function accepts its parameters
;	from these fields and may change user registers and flags by
;	changing these fields before returning to ISR21.

scsf_flags	dw	?		; user's flags.
scsf_cs         dw	?		; user's CS register.
scsf_ip         dw	?		; user's IP register.

scsf_es         dw	?
scsf_ds         dw	?
scsf_bp         dw	?
scsf_di         dw	?
scsf_si         dw	?
scsf_dx         dw	?
scsf_cx         dw	?
scsf_bx         dw	?
scsf_ax         dw	?

;	These fields are used to remember the caller's original stack.
;	The API functions don't mess with these; they are simply there
;	for ISR21 to figure out how to get back.

scsf_ss         dw	?
scsf_sp         dw	?

;	Here are some handy constants for use by API functions.

scsf_dosdata	dw	?		; seg FWA, DOSDATA.
scsf_dgroup	dw	?		; seg FWA, DGROUP.
scsf_psp	dw	?		; seg FWA, caller's PSP.

;	The original user registers.  API functions don't modify these,
;	but instead leave this copy around for critical error handling.

scsf_o_flags	dw	?		; user's flags.

scsf_o_es	dw	?
scsf_o_ds	dw	?
scsf_o_bp	dw	?
scsf_o_di	dw	?
scsf_o_si	dw	?
scsf_o_dx	dw	?
scsf_o_cx	dw	?
scsf_o_bx	dw	?
scsf_o_ax	dw	?

;	These fields are reserved for any API function's scratch purposes.

scsf_state	dw	?

scsf_count1	dw	?
scsf_count2	dw	?

scsf_handle	dw	?

scsf_addr1	dd	?
scsf_addr2	dd	?
scsf_addr3	dd	?
scsf_addr4	dd	?
scsf_addr5	dd	?
scsf_addr6	dd	?
scsf_addr7	dd	?
scsf_addr8	dd	?

;	The following is used in the DOS API handlers to easily maintain
;	all of the pointers to different I/O objects we need.  These fields
;	are scratch for the top-level DosXxx routines ONLY.

scsf_uhandle	dw	?		; user's handle to SHTE.
scsf_shandle	dw	?		; system handle to SHTE.
scsf_shte	dw	?		; FWA, SHTE itself.
scsf_sdte	dw	?		; FWA, SDTE itself.
scsf_status	dw	?		; old SHTE flags, etc.
scsf_buf	db	?		; character buffer.
		db	?		; for alignment.

;	You can grow this structure here without fear, as long as the
;	INT21 stack size is large enough.  Currently, they're 1k in size,
;	and that leaves about 512 bytes of room here for expansion.

SCSF		ends

scsf_al         equ	byte ptr scsf_ax
scsf_ah         equ	byte ptr scsf_ax+1

scsf_bl         equ	byte ptr scsf_bx
scsf_bh         equ	byte ptr scsf_bx+1

scsf_cl         equ	byte ptr scsf_cx
scsf_ch         equ	byte ptr scsf_cx+1

scsf_dl         equ	byte ptr scsf_dx
scsf_dh         equ	byte ptr scsf_dx+1
