/*---------------------------------------------------------------------------
**
**	DEBUGPRT.C
**
**
**	(c) 2001, ProSoft Technologies, Inc., All Rights Reserved
**	Ken D. Hopwood
**
**
**	MODIFIED :
**
**		01/24/2001 - 02/13/01 -- Created example code.
**		03/21/2001 -- Added comments
**
**
**	Title:	This file contains the debug port example code
**			for the ADM module.
**
**  Abstract:
**
**
**	This program may serve as a starting point or an example
**	for custom applications.
**
**  Environment:	MVI
**                  MS-DOS
**                  Borland C/C++ Compiler (16-bit)
**
**
** ProSoft Technology, Inc. grants you a non-exclusive license to use, modify
** and re-distribute this program provided that this copyright notice and
** license appear on all copies of the software.
**
** Software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR
** IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
** HEREBY EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE IS ASSUMED
** BY THE LICENSEE.
**
** PROSOFT TECHNOLOGY, INC. AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
** DAMAGES SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
** DISTRIBUTING SOFTWARE.  IN NO EVENT WILL PROSOFT TECHNOLOGY, INC. OR ITS
** LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
** CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
** OR INABILITY TO USE SOFTWARE, EVEN IF PROSOFT TECHNOLOGY, INC. HAS BEEN
** ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
**
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
**	COMPILER SWITCHES TO BUILD DIFFERENT VERSIONS OF THE SOFTWARE
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
**	Include files
**---------------------------------------------------------------------------
*/

#include "..\..\ADM-SAMPLE\inc\main_app.h"

#include <stdio.h>
#include <string.h>

/*---------------------------------------------------------------------------
**	CONSTANT DEFINITIONS
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
**	Function prototypes
**---------------------------------------------------------------------------
*/

int DebugMenu(void);


/*---------------------------------------------------------------------------
**	Variable definitions
**---------------------------------------------------------------------------
*/

static int displayed_msg = 0;

extern ADMHANDLE adm_handle;				/* handle to ADM API */
extern ADM_INTERFACE * interface_ptr;		/* pointer to interface struct */


/*---------------------------------------------------------------------------
**	Functions
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
**
**
**	Description:
**      Function to add a sub-menu to the debug port main menu.
**
**	Arguments:
**      None
**
**	External effects:
**
**
**	Return value:
**		int: menu state
**
**---------------------------------------------------------------------------
**	Notes:
**
**
**---------------------------------------------------------------------------
*/

int DebugMenu(void)
{
	int key;

	if(!displayed_msg)	/* display message only first time */
	{
		printf("\nUser Menu Selected\n");
		printf("Press ? For Help\n");
		displayed_msg = 1;
	}
	/* check for key input */
	key = ADM_CheckDBPort(adm_handle);

	if(key)
	{
		if(key >= 'a' && key <= 'z') //convert to upper case
			key &= 0x5f;

		switch(key)
		{
			case '1':   /* example selection */
				printf("Selection 1\n");
				break;

			case '2':   /* example selection */
				printf("Selection 2\n");
				break;

			case '?':	/* help menu */
				sprintf(interface_ptr->buff,"\nAUXILLIARY MENU\n\
 ?=Display Menu\n\
 1=Selection 1\n\
 2=Selection 2\n\
 M=Main Menu\n\n");
				/* set buffer pointer to first char and length to length of message */
				interface_ptr->buff_ch = 0;
				interface_ptr->buff_len = strlen(interface_ptr->buff);
				break;

			case 'M':
				printf("\nMain Menu Selected\n");
				displayed_msg = 0;
				return MAIN_MENU;
		}
	}
	return USER_MENU;
}





