////////////////////////////////////////////////////////////////////////////
//
//  MVI_GEN.C
//  This program has been modified from the previous work of others to serve
//  as a starting point for the fast implementation of custom protocols
//
//  Original work:
//  Rich Reynolds, Vital Computer Solutions
//  (c) 1999, Vital Computer Solutions
//  All Rights Reserved
//
//  Modified by:
//  Ken Hopwood, ProSoft Technology
//  (c) 2000, ProSoft Technology
//  Date    : 05/09/00  Develop LAS module for UK customer
//  Date    : 06/20/00  Develop GEN module
//
//
//
// ProSoft Technology, Inc. grants you a non-exclusive license to use, modify
// and re-distribute this program provided that this copyright notice and
// license appear on all copies of the software.
//
// Software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR
// IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
// HEREBY EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE IS ASSUMED
// BY THE LICENSEE.
//
// PROSOFT TECHNOLOGY, INC. AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
// DAMAGES SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
// DISTRIBUTING SOFTWARE.  IN NO EVENT WILL PROSOFT TECHNOLOGY, INC. OR ITS
// LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
// INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
// CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
// OR INABILITY TO USE SOFTWARE, EVEN IF PROSOFT TECHNOLOGY, INC. HAS BEEN
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//
////////////////////////////////////////////////////////////////////////////


#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include <stdlib.h>

#define  MVI_GEN               // preprocessor define for mvi_dfm.h file

#include "mvi_gen.h"
#include "admapi.h"        /* ADM API */

#define SOCKET_ENABLE
#ifdef SOCKET_ENABLE
#include "admnetapi.h"
#include "wattcp.h"
//#define MVI46
#define MVI56
//#define MVI71
#endif

int setup_module(void);
int shutdown_module(void);
int startup(void);


// LOCAL MODULE DATA

union int_or_float {
  int     i[4];
  float   fl[2];
} data_buff;


//---------------------- do not edit following code -----------------------
static void interrupt intctl_c(void);
static void interrupt intcrit(void);

// Ctrl-C signal handling function.  When a Ctrl-C is recognized, this function
// is called.  The function ignores the request and must reinstall the signal
// handler for future calls.

static void interrupt intctl_c(void)
{
	return;
}

static void interrupt intcrit(void)
{
	_AX = 0;   // ignore critical error
}
//--------------------- ok to edit following code ---------------------------

#ifdef SOCKET_ENABLE

#if defined(MVI46)
char sockName1[] = "ReceiveSocket";
int buffSize1 = 4096;
int port_1 = 6565;
int numSocket1 = 5;
#elif defined(MVI71)
char sockName2[] = "SendSocket";
int buffSize2 = 500;
int port_2 = 6666;
int numSocket2 = 1;
#endif

#endif

void main(void)
{
	BYTE str1[20];              // buffer used for port 1
	BYTE str2[20];              // buffer used for port 2
	int len1, len2;             // buffer length variables used in code
	int sptr1, sptr2, rc;

#ifdef SOCKET_ENABLE
#if defined(MVI46)
	char holdingReg[100];
	int readLen = 0, i;
#elif defined(MVI71)
	int sendLen = 0;
#endif
#endif

#ifdef __DMC__
	extern int _8087;

	_8087 = 0; /* never use 80x87 Math Coprocessor */
#endif

	/* enable console on COM1 */
	ADM_SetConsolePort(COM1);
	/* set console to 57600 baud */
	ADM_SetConsoleSpeed(COM1, 57600L);

	//----------- do not edit next 6 lines of code---------------------------
	disable();
	setvect(0x24, intcrit);     // install in ISR handler for CTRL-C
	setvect(0x23, intctl_c);    // install in ISR handler for CTRL-C
	setvect(0x1B, intctl_c);    // install in ISR handler for CTRL-Break
	setcbrk(0);                 // force DOS to ignore Ctrl-C
	enable();


	if(!setup_module())         // Initialize hardware and load drivers
	{
		printf("Error: Can't initialize setup\n");
		shutdown_module();      // if fail on init then shutdown
		return;
	}

#ifdef SOCKET_ENABLE
	/* initialize TCP/IP socket */
	printf("Ethernet Initialization\n");
	sock_init();    //initialize the socket interface
#if defined(MVI46)
	/* initialize each socket */
	printf("Socket %s Initialization\n", sockName1);
	if(ADM_init_socket(numSocket1, port_1, buffSize1, sockName1) != SK_SUCCESS)
	{
		printf("Error: Can't initialize socket = %s\n", sockName1);
		ADM_release_sockets();
	}
#elif defined(MVI71)
	/* initialize each socket */
	printf("Socket %s Initialization\n", sockName2);
	if(ADM_init_socket(numSocket2, port_2, buffSize2, sockName2) != SK_SUCCESS)
	{
		printf("Error: Can't initialize socket = %s\n", sockName2);
		ADM_release_sockets();
	}
#endif
#endif

	sptr1 = 0;
	sptr2 = 0;

	for(;;)                     // Main loop for program
	{

#ifdef SOCKET_ENABLE
#if defined(MVI46)
	if((rc = ADM_receive_socket(sockName1, holdingReg, &readLen, USE_UDP)) == SK_SUCCESS)
	{
		printf("Length == %d\n", readLen);
		for (i=0; i<readLen; i++)
		{
			printf("%02X ", *(holdingReg+i));
			if(i%10 == 0) printf("\n");
		}
		printf("\n");
	}
#elif defined(MVI71)
	sendLen = 34;
	if(ADM_send_socket(sockName2, "Receive From MVI71 (192.168.0.147)", &sendLen, "192.168.0.146", USE_TCP) == SK_SUCCESS)
	{
		printf("Send To PTQ (192.168.0.146)\n");
	}
#endif
#endif
								// program moves data across the backplane in one transfer
								// in the following structure through the Input Image
								// Word 0 : Status word
								//           - Bit 0 : toggles on new value on port 1
								//           - Bit 1 : toggles on new value on port 2
								// Word 1 : Port 1 data value
								// Word 2 : Port 1 data value
								// Word 3 : Port 2 data value
								// Word 4 : Port 2 data value
								// Word 5 : Port 1 Receive counter(rollover signed counter)
								// Word 6 : Port 2 Receive counter(rollover signed counter)
								// Word 7 : Code Loop Counter - Health indication if no comm

		// Port 1 handler logic
		len1 = 16;
		// Get chars from COM port. If LF is found, process string
		if(MVIsp_Gets(COM2, &str1[sptr1], _LF, &len1, TIMEOUT_ASAP) == MVI_SUCCESS)
		{
			// following is example of moving a floating point value, w/ words swapped for PLC format
			// sscanf((char *)str1,"%f",&data_buff.fl[0]); // scan data as a float
			// *(wrbuff+1) = data_buff.i[1];           // write float as ints to backplane and swap
			// *(wrbuff+2) = data_buff.i[0];

			// following is example of moving a decimal (signed) value.  Second word is set to zero
			sscanf((char *)str1,"%d",&data_buff.i[0]);  // scan data as a decimal value
			*(wrbuff+1) = data_buff.i[0];               // write value to backplane image
			*(wrbuff+2) = 0;

			*wrbuff = (*wrbuff & 0x0001) ^ 0x0001;      // status word (toggle bit)
			*(wrbuff+5) = *(wrbuff+5) + 1;              // receive counter for COM 2
			sptr1 = 0;
			len1 = 0;
		}
		if(len1 > 0)
		{
			sptr1 = sptr1 + len1;						// bump string pointer
		}

		// Set user LED2 off
		MVIbp_SetUserLED(mod_handle, MVI_LED_USER2, MVI_LED_STATE_OFF);

		// Port 2 handler logic
		len2 = 16;
		// Get chars from COM port. If LF is found, process string
		if(MVIsp_Gets(COM3, &str2[sptr2], _LF, &len2, TIMEOUT_ASAP) == MVI_SUCCESS)
		{
			// following is example of moving a floating point value, w/ words swapped for PLC format
			// sscanf((char *)str2,"%f",&data_buff.fl[1]);
			// *(wrbuff+3) = data_buff.i[3];
			// *(wrbuff+4) = data_buff.i[2];

			// following is example of moving a decimal (signed) value.  Second word is set to zero
			sscanf((char *)str2,"%d",&data_buff.i[2]);  // scan data as a decimal value
			*(wrbuff+3) = data_buff.i[2];               // write value to backplane image
			*(wrbuff+4) = 0;

			*wrbuff = (*wrbuff & 0x0002) ^ 0x0002;  	// status word (toggle bit)
			*(wrbuff+6) = *(wrbuff+6) + 1;				// receive counter for COM 3
			sptr2 = 0;
			len2 = 0;
		}
		if(len2 > 0)
		{
			sptr2 = sptr2 + len2;                       // bump string pointer
		}

		*(wrbuff+7) = *(wrbuff+7) + 1;      			// increment loop counter for external health indication

		// write image to backplane
		MVIbp_WriteInputImage(mod_handle, wrbuff, 0, 8);

		// Set user LED2 on to indicate write to I/O
		MVIbp_SetUserLED(mod_handle, MVI_LED_USER2, MVI_LED_STATE_ON);
	}
}


///////////////////////////////////////////////////////////////////////////////
//
// This function is used to setup the module's hardware and load device
// drivers required by the application.  Most of the items to look at closely
// are going to be related to the serial port configuration value at the top of
// of the function.
//
// Input : None.
// Output: The function returns a value of 1 if successful and 0 if not.
//
///////////////////////////////////////////////////////////////////////////////

int setup_module(void)
{
	int se;

	// Open serial interface API
	// Set comm parameters
	printf("Open com port%d\n", COM2);
	se = MVIsp_Open(COM2, BAUD_9600, PARITY_NONE, WORDLEN8, STOPBITS1);
	if(se != MVI_SUCCESS)
	{
			printf("ERROR: Cannot open COM%d application port!\n", COM2);
		return 0;
	}
	printf("Open com port%d\n", COM3);
	se = MVIsp_Open(COM3, BAUD_9600, PARITY_NONE, WORDLEN8, STOPBITS1);
	if(se != MVI_SUCCESS)
	{
			printf("ERROR: Cannot open COM%d application port!\n", COM3);
		return 0;
	}
	// Set comm handshaking
	MVIsp_SetHandshaking(COM2, HSHAKE_NONE);
	MVIsp_SetHandshaking(COM3, HSHAKE_NONE);

	// Set up the backplane interface API
	se = MVIbp_Open(&mod_handle);
	if(se != MVI_SUCCESS)
	{
		printf("ERROR: Backplane failed!\n");
		return 0;
	}

	// Set module status LED
	MVIbp_SetModuleStatus(mod_handle, MVI_MODULE_STATUS_OK);

	// Set user LED1 on to indicate program running
	MVIbp_SetUserLED(mod_handle, MVI_LED_USER1, MVI_LED_STATE_ON);

	return 1;
}

///////////////////////////////////////////////////////////////////////////////
//
// This function is used to shutdown the module's hardware and device drivers.
//
// Input : None.
// Output: The function will always return a value of 1.
//
///////////////////////////////////////////////////////////////////////////////

int shutdown_module(void)
{
	MVIbp_SetUserLED(mod_handle, MVI_LED_USER1, MVI_LED_STATE_OFF);
	MVIbp_SetUserLED(mod_handle, MVI_LED_USER2, MVI_LED_STATE_OFF);
	MVIbp_SetModuleStatus(mod_handle, MVI_MODULE_STATUS_FAULTED);

#ifdef SOCKET_ENABLE
	printf("Releasing Sockets....");
	ADM_release_sockets();
#endif

	MVIbp_Close(mod_handle);
	MVIsp_Close(COM2);
	MVIsp_Close(COM3);

	return 1;
}

