/*
// PROGRAM NAME:  SHAREMEM.C.
//
// FUNCTIONAL DESCRIPTION.
//	This program is a simple example of how the executive shared memory
//	functions can be called from large-model C applications.  The program
//	creates a shared memory object called FOO, writes some data to the
//	shared memory area, then accesses the same memory object by name,
//	compares the data, and deaccesses/deletes the shared memory region.
//
// MODIFICATION HISTORY.
//	S. E. Jones	93/09/18.	#1.106, original.
//
// INPUTS.
//	none.
//
// OUTPUTS.
//	none.
//
// COMMAND LINE ARGUMENTS.
//	none.
//
// NOTICE:  Copyright (C) 1993-1995 General Software, Inc.
*/

#define VOID void
#define UCHAR unsigned char
#define USHORT unsigned short
#define ULONG unsigned long
#define FALSE 0
#define TRUE (!FALSE)

#include <stdio.h>

#include "..\inc\shrmem.h"	 // shared memory API definitions.

VOID main (int argc, char *argv[])
{
    UCHAR *Buf1, *Buf2;

    printf ("This is a simple C program that uses shared memory.\n");

    if (!ExAllocateSharedMemory ("MY_DATA", 50, &Buf1)) {
	printf ("The MY_DATA shared memory could not be created.\n");
	exit (-1);
    }

    strcpy (Buf1, "This is the test data.");

    if (!ExAccessSharedMemory ("MY_DATA", &Buf2)) {
	ExDeallocateSharedMemory (Buf1);
	printf ("The MY_DATA shared memory block could not be accessed.\n");
	exit (-1);
    }

    //
    // Compare the two pointers; they should be identical.
    //

    if (Buf1 != Buf2) {
	ExDeaccessSharedMemory (Buf2);
	ExDeallocateSharedMemory (Buf1);
	printf ("The pointers were not the same.\n");
	exit (-1);
    }
    printf ("The shared memory pointers are identical.\n");

    //
    // Clean up and return to DOS.
    //

    ExDeaccessSharedMemory (Buf2);
    ExDeallocateSharedMemory (Buf1);
    exit (0);			// successfully return to Embedded DOS.
} // sharemem.c
