;***	BPB.INC -- Embedded DOS BIOS Parameter Block.
;
;1.	Functional Description.
;	This include file contains the format of a BIOS Parameter Block as
;	found in a Partition Boot Record (PBR).
;
;	We extend the meaning of the bpb_MD field by allowing low values that
;	directly map to the partition type.  In this way, we support ALL file
;	systems through the disk driver.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/02/03.	Added bpb_MD support of partition types.
;	S. E. Jones	91/02/17.	Added bpb_PartOfs, bpb_StartCyl.
;	S. E. Jones	91/02/17.	Changed defn of bpb_HS.
;	S. E. Jones	91/07/14.	#1.086, split off driver portions into DBPB.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

BPB		struc
bpb_BPS         dw	?		; bytes per sector.
bpb_SPC         db	?		; sectors per cluster.
bpb_RS		dw	?		; reserved sectors (in the boot record).
bpb_NFAT	db	?		; number of FATs.
bpb_MDE         dw	?		; max directory entries in root dir.
bpb_TS		dw	?		; total sectors.
bpb_MD		db	?		; media descriptor.
bpb_SPF         dw	?		; sectors per FAT.
bpb_SPT         dw	?		; sectors per track.
bpb_NH		dw	?		; number of heads.

;	The following two fields are extensions to the standard BPB.
;	If the bpb_TS field is zero, then bpb_ETS contains the real
;	extended total sectors.

bpb_HS		dd	?		; hidden sectors (from MBR).
bpb_ETS         dd	?		; extended total sectors.
BPB		ends
